//=============================================================================
// imp.
//=============================================================================
class Enemy_Imp expands Enemy;

#exec MESH IMPORT MESH=imp ANIVFILE=Models\Enemies\Imp\imp_a.3d DATAFILE=Models\Enemies\Imp\imp_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=imp X=0 Y=0 Z=-30

#exec MESH SEQUENCE MESH=imp SEQ=All    STARTFRAME=0 NUMFRAMES=34 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Breath STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Crouch STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=die1 STARTFRAME=17 NUMFRAMES=16 RATE=15
#exec MESH SEQUENCE MESH=imp SEQ=die2 STARTFRAME=17 NUMFRAMES=16 RATE=15
#exec MESH SEQUENCE MESH=imp SEQ=die3 STARTFRAME=17 NUMFRAMES=16 RATE=15
#exec MESH SEQUENCE MESH=imp SEQ=die4 STARTFRAME=17 NUMFRAMES=16 RATE=15
#exec MESH SEQUENCE MESH=imp SEQ=Fighter       STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Hit          STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=HeadHit      STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=LeftHit      STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=GutHit       STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=RightHit     STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Jump         STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Land		    STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Look         STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=run STARTFRAME=1 NUMFRAMES=8 RATE=7
#exec MESH SEQUENCE MESH=imp SEQ=Shoot1 STARTFRAME=7 NUMFRAMES=15 RATE=10 Group=Attack
#exec MESH SEQUENCE MESH=imp SEQ=ThreatShoot1 STARTFRAME=7 NUMFRAMES=15 RATE=10 
#exec MESH SEQUENCE MESH=imp SEQ=Shoot2       STARTFRAME=7 NUMFRAMES=15 RATE=10 GROUP=MovingAttack
#exec MESH SEQUENCE MESH=imp SEQ=Strike1      STARTFRAME=7 NUMFRAMES=15 RATE=10 Group=Attack
#exec MESH SEQUENCE MESH=imp SEQ=Strike2      STARTFRAME=7 NUMFRAMES=15 RATE=10 Group=Attack
#exec MESH SEQUENCE MESH=imp SEQ=Strike3      STARTFRAME=7 NUMFRAMES=15 RATE=10 Group=Attack
#exec MESH SEQUENCE MESH=imp SEQ=Swim         STARTFRAME=1 NUMFRAMES=8 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=T3           STARTFRAME=0 NUMFRAMES=1 RATE=10
#exec MESH SEQUENCE MESH=imp SEQ=Throw        STARTFRAME=0 NUMFRAMES=1 RATE=10
#exec MESH SEQUENCE MESH=imp SEQ=Twirl        STARTFRAME=0 NUMFRAMES=1 RATE=10
#exec MESH SEQUENCE MESH=imp SEQ=walk STARTFRAME=1 NUMFRAMES=8 RATE=6
#exec MESH SEQUENCE MESH=imp SEQ=Grasp        STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=HeadRub      STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Laugh        STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Toss         STARTFRAME=0 NUMFRAMES=1 RATE=5
#exec MESH SEQUENCE MESH=imp SEQ=Dead5        STARTFRAME=17 NUMFRAMES=16 RATE=15




#exec TEXTURE IMPORT NAME=Jimp1 FILE=Textures\Enemies\Imp\Jimp1.bmp GROUP=Skins FLAGS=2 // Material #1

#exec MESHMAP NEW   MESHMAP=imp MESH=imp
#exec MESHMAP SCALE MESHMAP=imp X=0.1 Y=0.1 Z=0.2

//#exec MESHMAP SETTEXTURE MESHMAP=imp NUM=1 TEXTURE=Jimp1

#exec MESH NOTIFY MESH=imp SEQ=Shoot1 TIME=0.25 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=imp SEQ=Shoot2 TIME=0.48 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=imp SEQ=Shoot2 TIME=0.8 FUNCTION=ShotMove
#exec MESH NOTIFY MESH=imp SEQ=Shoot2 TIME=0.35 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=imp SEQ=Strike1 TIME=0.375 FUNCTION=StrikeDamageTarget
#exec MESH NOTIFY MESH=imp SEQ=Strike2 TIME=0.5 FUNCTION=StrikeDamageTarget
#exec MESH NOTIFY MESH=imp SEQ=Strike3 TIME=0.26 FUNCTION=PoundDamageTarget
#exec MESH NOTIFY MESH=imp SEQ=Throw TIME=0.19 FUNCTION=ThrowDamageTarget
#exec MESH NOTIFY MESH=imp SEQ=Throw TIME=0.42 FUNCTION=ThrowTarget
#exec MESH NOTIFY MESH=imp SEQ=Grasp TIME=0.58 FUNCTION=GrabDice
#exec MESH NOTIFY MESH=imp SEQ=Toss  TIME=0.63 FUNCTION=ThrowDice
#exec MESH NOTIFY MESH=imp SEQ=Die1  TIME=0.64 FUNCTION=LandThump
#exec MESH NOTIFY MESH=imp SEQ=Die2  TIME=0.81 FUNCTION=LandThump
#exec MESH NOTIFY MESH=imp SEQ=Die3  TIME=0.54 FUNCTION=LandThump
#exec MESH NOTIFY MESH=imp SEQ=Die4  TIME=0.75 FUNCTION=LandThump
#exec MESH NOTIFY MESH=imp SEQ=Dead5 TIME=0.83 FUNCTION=LandThump


var() byte StrikeDamage,
	ThrowDamage,
	PoundDamage;
var bool AttackSuccess;
var() bool bSpearToss;
var() bool bDicePlayer;
var() bool bSleeping;
var   bool bHasDice;
var	  bool bHeldDice;
var(Sounds) sound strike1;
var(Sounds) sound strike2;
var(Sounds) sound twirl;
var(Sounds) sound syllable1;
var(Sounds) sound syllable2;
var(Sounds) sound syllable3;
var(Sounds) sound syllable4;
var(Sounds) sound syllable5;
var(Sounds) sound syllable6;
var(Sounds) sound die2;
var(Sounds)	sound spearHit;
var(Sounds) sound spearThrow;
var 	name phrase;
var		byte phrasesyllable;
var		float	voicePitch;
var Dice Toy1;
var Dice Toy2;
var()	float MinDuckTime;
var		float LastDuckTime;

function PreloadMeshes()	//never called, only here to force enemy meshes to exist!
{
	Spawn( Class 'Enemy_Cyborg' );
	Spawn( Class 'Enemy_Imp' );
	Spawn( Class 'Enemy_Scorpion' );
	Spawn( Class 'Enemy_Spinner' );
}

function PreBeginPlay()
{
	bCanSpeak = true;
	voicePitch = 0.25 + 0.5 * FRand();
	if ( CombatStyle == Default.CombatStyle)
		CombatStyle = CombatStyle + 0.4 * FRand() - 0.2;
	bCanDuck = (FRand() < 0.5);
	Super.PreBeginPlay();
	if ( bDicePlayer )
		PeripheralVision = 1.0; 
	if ( Skill == 0 )
		ProjectileSpeed *= 0.85;
	else if ( Skill > 2 )
	{
		bCanStrafe = true;
		ProjectileSpeed *= 1.1;
	}

		bLeadTarget = false;
}





function ZoneChange(ZoneInfo newZone)
{
	bCanSwim = newZone.bWaterZone; //only when it must
		
	if ( newZone.bWaterZone )
		CombatStyle = 1.0; //always charges when in the water
	else if (Physics == PHYS_Swimming)
		CombatStyle = Default.CombatStyle;

	Super.ZoneChange(newZone);
}

function SetMovementPhysics()
{
	if ( Region.Zone.bWaterZone )
		SetPhysics(PHYS_Swimming);
	else if (Physics != PHYS_Walking)
		SetPhysics(PHYS_Walking); 
}



//=========================================================================================
// Speech


function SpeechTimer()
{
	//last syllable expired.  Decide whether to keep the floor or quit
	if (FRand() < 0.3)
	{
		bIsSpeaking = false;
		if (TeamLeader != None)
			TeamLeader.bTeamSpeaking = false;
	}
	else
		Speak();
}

function SpeakOrderTo(Enemy TeamMember)
{

}

function Speak()
{
	local float decision;
	
	//if (phrase != '')
	//	SpeakPhrase();
	bIsSpeaking = true;
	decision = FRand();
	if (TeamLeader != None)	
		TeamLeader.bTeamSpeaking = true;
	if (decision < 0.167)
		PlaySound(Syllable1,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.333)
		PlaySound(Syllable2,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.5)
		PlaySound(Syllable3,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.667)
		PlaySound(Syllable4,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else if (decision < 0.833)
		PlaySound(Syllable5,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);
	else 
		PlaySound(Syllable6,SLOT_Talk,0.3 + FRand(),,, FRand() + voicePitch);

	SpeechTime = 0.1 + 0.3 * FRand();
}
	
function PlayAcquisitionSound()
{
	if ( bCanSpeak && (TeamLeader != None) && !TeamLeader.bTeamSpeaking )
	{
		phrase = 'Acquisition';
		phrasesyllable = 0;
		Speak();
		return;
	}
	Super.PlayAcquisitionSound(); 
}

function PlayFearSound()
{
	if ( bCanSpeak && (TeamLeader != None) && !TeamLeader.bTeamSpeaking )
	{
		phrase = 'Fear';
		phrasesyllable = 0;
		Speak();
		return;
	}
	Super.PlayFearSound(); 
}

function PlayRoamingSound()
{
	if ( bCanSpeak && (TeamLeader != None) && !TeamLeader.bTeamSpeaking  && (FRand() < 0.5) )
	{
		phrase = '';
		Speak();
		return;
	} 
	Super.PlayRoamingSound();
}

function PlayThreateningSound()
{
	if ( bCanSpeak && (FRand() < 0.6) && ((TeamLeader == None) || !TeamLeader.bTeamSpeaking) )
	{
		phrase = 'Threaten';
		phrasesyllable = 0;
		Speak();
		return;
	} 
	Super.PlayThreateningSound();
}



function ThrowDice()
{

}



function PlayWaiting()
{
	local float decision;
	local float animspeed;
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}

	if ( bSleeping )
	{
		animspeed = 0.5 + 0.5 * FRand(); 
		SetAlertness(-1.0);
		LoopAnim('Sleep1', AnimSpeed );
		PlaySound(sound'Snore1K',SLOT_Talk);
		return;
	}

	decision = FRand();

	

	if (AnimSequence == 'Look')
	{
		SetAlertness(0.0);
		if (!bQuiet && decision < 0.3) 
		{
			LoopAnim('Twirl', 0.3 + 0.6 * FRand());
		    PlaySound(Twirl,SLOT_Interact,0.5,,500);
		}	
		else 
			LoopAnim('Breath', 0.2 + 0.7 * FRand());
		return;
	}
 	else if (AnimSequence == 'Twirl')
	{
 		SetAlertness(0.0);
 		if (decision < 0.5) 
		{
		    PlaySound(Twirl,SLOT_Interact,0.5,,500);	
			LoopAnim('Twirl', 0.3 + 0.6 * FRand());
		}
		else 
			LoopAnim( 'Breath', 0.2 + 0.7 * FRand());
		return;
	}
	
	if (decision < 0.2)
	{
		SetAlertness(0.5);
		LoopAnim('Look', 0.2 + 0.7 * FRand());
	}
	else
	{
		SetAlertness(0.0);
		LoopAnim('Breath', 0.2 + 0.7 * FRand());
	}
}

function PlayPatrolStop()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
		
	if ( (AnimSequence == 'Breath') && (FRand() < 0.4) )
	{
		SetAlertness(0.5);
		LoopAnim('Look', 0.2 + 0.7 * FRand());
		return;
	}
	else if ( !bQuiet && (AnimSequence == 'Look') && (FRand() < 0.3) )
	{
		SetAlertness(0.0);
	    PlaySound(Twirl,SLOT_Interact,0.5,,500);	
		LoopAnim('Twirl', 0.3 + 0.6 * FRand());
		return;
	}
 	else if ( (AnimSequence == 'Twirl') && (FRand() < 0.5) )
	{
 		SetAlertness(0.0);
	    PlaySound(Twirl,SLOT_Interact,0.5,,500);	
		LoopAnim('Twirl', 0.3 + 0.6 * FRand());
		return;
	}
	SetAlertness(0.0);
	LoopAnim('Breath', 0.2 + 0.7 * FRand());
}
	
function PlayWaitingAmbush()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if (FRand() < 0.4)
		LoopAnim('Look', 0.3);
	else 
		LoopAnim('Breath', 0.3 + 0.5 * FRand());
}

function PlayChallenge()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	if ( TryToCrouch() )
	{
		TweenAnim('Crouch', 0.12);
		return;
	}	
	PlayThreateningSound();
	PlayAnim('T3', 0.7, 0.15);
}

function PlayDive()
{
	TweenToSwimming(0.2);
}

function TweenToFighter(float tweentime)
{
	if ( bDicePlayer )
	{
		PeripheralVision = Default.PeripheralVision;
		bDicePlayer = false;
	}
	bSleeping = false;
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	TweenAnim('Fighter', tweentime);
}

function TweenToRunning(float tweentime)
{
	if ( bDicePlayer )
	{
		PeripheralVision = Default.PeripheralVision;
		bDicePlayer = false;
	}
	bSleeping = false;
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	if ( (AnimSequence == 'Shoot2') && IsAnimating() )
		return;
	if ( (AnimSequence != 'Run') || !bAnimLoop )
		TweenAnim('Run', tweentime);
}

function TweenToWalking(float tweentime)
{
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	TweenAnim('Walk', tweentime);
}

function TweenToWaiting(float tweentime)
{
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	if ( bDicePlayer ) 
	{
		TweenAnim('Breath2', tweentime);
		return;
	}
	TweenAnim('Breath', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	if (Region.Zone.bWaterZone)
	{
		TweenToSwimming(tweentime);
		return;
	}
	TweenAnim('Breath', tweentime);
}

function TweenToFalling()
{
	TweenAnim('Jump', 0.35);
}

function PlayInAir()
{
	TweenAnim('Jump', 0.2);
}

function PlayOutOfWater()
{
	TweenAnim('Land',0.8);
}

function PlayLanded(float impactVel)
{
	TweenAnim('Land', 0.1);
}

function PlayMovingAttack()
{
	if (Region.Zone.bWaterZone)
	{
		PlayAnim('SwimFire');
		SpawnShot();
		return;
	}
	DesiredSpeed = 0.4;
	MoveTimer += 0.2;
	PlayAnim('Shoot2');
}

function PlayRunning()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}

	DesiredSpeed = 1.0;
	if (Focus == Destination)
	{
		LoopAnim('Run', -1.0/GroundSpeed,, 0.4);
		return;
	}	
	LoopAnim('Run', StrafeAdjust(),,0.3);
}

function PlayWalking()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	LoopAnim('Walk', 0.88);
}

function TweenToSwimming(float tweentime)
{
	if ( (AnimSequence != 'Swim') || !bAnimLoop )
		TweenAnim('Swim', tweentime);
}

function PlaySwimming()
{
	LoopAnim('Swim', -1.0/WaterSpeed,,0.3);
}

function PlayThreatening()
{
	local float decision, animspeed;

	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	decision = FRand();
	animspeed = 0.4 + 0.6 * FRand(); 

	if ( decision < 0.6 )
		PlayAnim('Breath', animspeed, 0.3);
	else if ( decision < 0.7 )
	{
	    PlaySound(Twirl,SLOT_Interact,0.5,,500);	
		PlayAnim('Twirl', animspeed, 0.3);
	}
	else 
	{
		PlayThreateningSound();
		if ( decision < 0.8 )
			PlayAnim('T3', animspeed, 0.3);
		else if ( decision < 0.9 )
			PlayAnim('ThreatShoot1', 0.3, 0.3);
		else 
			TweenAnim('Fighter', 0.3);
	}
}

function PlayTurning()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	TweenAnim('Walk', 0.3);
}

function PlayBigDeath(name DamageType)
{
	PlaySound(Die2, SLOT_Talk, 4 * TransientSoundVolume);
	PlayAnim('Die2',0.7,0.1);
}

function PlayHeadDeath(name DamageType)
{
	local carcass carc;

	if ( ((DamageType == 'Decapitated') || ((Health < -20) && (FRand() < 0.5)))
		 && !Level.Game.bVeryLowGore )
	{
		carc = Spawn(class 'CreatureChunks',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
		if (carc != None)
		{
			carc.Mesh = mesh'KrallHead';
			carc.Initfor(self);
			carc.Velocity = Velocity + VSize(Velocity) * VRand();
			carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
		}
		PlayAnim('Dead5',0.7,0.1);
		if ( Velocity.Z < 120 )
		{
			Velocity = GroundSpeed * vector(Rotation);
			Velocity.Z = 150;
		}
	}
	else if ( FRand() < 0.5 )
		PlayAnim('Die4',0.7,0.1);
	else
		PlayAnim('Die3',0.7,0.1);
	PlaySound(Die, SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayLeftDeath(name DamageType)
{
	PlayAnim('Die4',0.7, 0.1);
	PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayRightDeath(name DamageType)
{
	PlayAnim('Die3',0.7,0.1);
	PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayGutDeath(name DamageType)
{
	if ( Velocity.Z > 100 )
		PlayAnim('Die3',0.7,0.1);
	else
		PlayAnim('Die1',0.7,0.1);
	PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayVictoryDance()
{
    PlaySound(Twirl,SLOT_Interact,0.5,,500);	
	PlayAnim('Twirl', 0.5, 0.1);
}

function bool CanFireAtEnemy()
{
	local vector HitLocation, HitNormal,X,Y,Z, projStart, EnemyDir, EnemyUp;
	local actor HitActor;
	local float EnemyDist;
		
	EnemyDir = Enemy.Location - Location;
	EnemyDist = VSize(EnemyDir);
	EnemyUp = Enemy.CollisionHeight * vect(0,0,0.9);
	if ( EnemyDist > 300 )
	{
		EnemyDir = 300 * EnemyDir/EnemyDist;
		EnemyUp = 300 * EnemyUp/EnemyDist;
	}
	
	GetAxes(Rotation,X,Y,Z);
	projStart = Location + 0.9 * CollisionRadius * X - 0.7 * CollisionRadius * Y;
	HitActor = Trace(HitLocation, HitNormal, projStart + EnemyDir + EnemyUp, projStart, true);

	if ( (HitActor == None) || (HitActor == Enemy) 
		|| ((Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) <= ATTITUDE_Ignore)) )
		return true;

	HitActor = Trace(HitLocation, HitNormal, projStart + EnemyDir, projStart , true);

	return ( (HitActor == None) || (HitActor == Enemy) 
			|| ((Pawn(HitActor) != None) && (AttitudeTo(Pawn(HitActor)) <= ATTITUDE_Ignore)) );
}
	
function SpawnShot()
{
	DesiredSpeed = 0.0; //For Kraal shoot2 (walking shoot, w/ pause)
	FireProjectile( vect(0.9, -0.5, 0), 500);
}

function ShotMove()
{
	DesiredSpeed = 1.0;
}

function StrikeDamageTarget()
{
	if (MeleeDamageTarget(StrikeDamage, StrikeDamage * 700 * Normal(Target.Location - Location)))
		PlaySound(SpearHit,SLOT_Interact);
}

function PoundDamageTarget()
{
	if (MeleeDamageTarget(PoundDamage, PoundDamage * 500 * Normal(Target.Location - Location)))
		PlaySound(SpearHit,SLOT_Interact);
}

function ThrowDamageTarget()
{
	AttackSuccess = MeleeDamageTarget(ThrowDamage, vect(0,0,0));
}

function ThrowTarget() 
{
	local rotator newRot;
	if (AttackSuccess && (Vsize(Target.Location - Location) < CollisionRadius + Target.CollisionRadius + 1.5 * MeleeRange) )
	{
		PlaySound(SpearThrow,SLOT_Interact);
		newRot = Target.Rotation;
		newRot.Pitch = 4096;
		Target.SetRotation(newRot);
		if (Pawn(Target) != None)
		{
			Pawn(Target).AddVelocity( 
				(50000.0 * (Normal(Target.Location - Location) + vect(0,0,1)))/Target.Mass);
			if (PlayerPawn(Target) != None)
				PlayerPawn(Target).ShakeView(0.2, 2000, -10);
		}
	}
}
	
function PlayMeleeAttack()
{
	local float decision;

	decision = FRand();
	if (!bSpearToss)
		decision *= 0.7;
	if (decision < 0.2)
	{
		PlayAnim('Strike1'); 
		PlaySound(Strike1,SLOT_Interact);
	}
 	else if (decision < 0.4)
 	{
   		PlayAnim('Strike2');
   		PlaySound(Strike2,SLOT_Interact);
   	}
 	else if (decision < 0.7)
 	{
 		PlayAnim('Strike3');
 		PlaySound(Strike1,SLOT_Interact);
 	}
 	else
 	{
 		PlayAnim('Throw');
 		PlaySound(Strike2,SLOT_Interact);
 	} 
}

function PlayRangedAttack()
{
	local float tweenin;
	
	if (Region.Zone.bWaterZone)
	{
		PlayAnim('SwimFire');
		SpawnShot();
		return;
	}
	if (AnimSequence == 'Shoot1')
		tweenin = 0.3 * FRand();
	else
		tweenin = 0.35;
	PlayAnim('Shoot1', 1.0, tweenin);
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function TweenToRunning(float tweentime)
	{
		if ( bDicePlayer )
		{
			PeripheralVision = Default.PeripheralVision;
			bDicePlayer = false;
		}
		if (Region.Zone.bWaterZone)
		{
			TweenToSwimming(tweentime);
			return;
		}
		if ( bCanStrafe && (AnimSequence == 'Shoot2') && IsAnimating() )
			return;
		if ( (AnimSequence != 'Run') || !bAnimLoop )
			TweenAnim('Run', tweentime);
	}
}
	

defaultproperties
{
    HUDname="Imp"
	HUDcolor=(R=255,G=0,B=0)
    StrikeDamage=20
    ThrowDamage=30
    PoundDamage=20
    bSpearToss=True
    Strike1=Sound'UnrealI.Krall.strike1k'
    Strike2=Sound'UnrealI.Krall.strike1k'
    Twirl=Sound'UnrealI.Krall.staflp4k'
    syllable1=Sound'UnrealI.Krall.syl1kr'
    syllable2=Sound'UnrealI.Krall.syl2kr'
    syllable3=Sound'UnrealI.Krall.syl3kr'
    syllable4=Sound'UnrealI.Krall.syl4kr'
    syllable5=Sound'UnrealI.Krall.syl5kr'
    syllable6=Sound'UnrealI.Krall.syl6kr'
    Die2=Sound'UnrealI.Krall.death2k'
    spearHit=Sound'UnrealI.Krall.hit2k'
    spearThrow=Sound'UnrealI.Krall.throw1k'
    MinDuckTime=8.00
    CarcassType=Class'UnrealI.KrallCarcass'
    Aggressiveness=0.50
    RefireRate=0.50
    bHasRangedAttack=True
    bMovingRangedAttack=True
    bLeadTarget=False
    RangedProjectile=Class'Projectile_RedFlameBall'
	ProjectileSpeed=1200
    Acquire=Sound'UnrealI.Krall.chlng1k'
    Fear=Sound'UnrealI.Krall.chlng2k'
    Threaten=Sound'UnrealI.Krall.chlng2k'
    MeleeRange=50.00
    GroundSpeed=240.00
    AirSpeed=240.00
    AccelRate=500.00
    JumpZ=360.00
    HearingThreshold=0.00
    Health=180
    Intelligence=3
    HitSound1=Sound'UnrealI.Krall.injur1k'
    HitSound2=Sound'UnrealI.Krall.injur2k'
    Die=Sound'UnrealI.Krall.death1k'
    CombatStyle=0.80
    AmbientSound=Sound'UnrealI.Krall.amb1kr'
    DrawType=2
    Mesh=LodMesh'imp'
	Texture=Texture'Jimp1'
    DrawScale=2.00
    TransientSoundVolume=1.50
    CollisionRadius=25.00
    CollisionHeight=46.00
    Mass=140.00
    Buoyancy=140.00
    RotationRate=(Pitch=3072,Yaw=60000,Roll=0),
}
